﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Admin/Ei8htPOS.Master" AutoEventWireup="true" CodeBehind="Sales.aspx.cs" Inherits="AZVIC.Ei8htPOS.WebUI.Admin.Sales.SalesOrder" %>
<%@ MasterType VirtualPath="~/Admin/Ei8htPOS.Master" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <asp:HiddenField ID="hdOrderID" runat="server" />
    <div class="pageheader">
        <h2>
            <i class="fa fa-cubes"></i> Sales Management
        </h2>
        <div class="breadcrumbs">
            <ol class="breadcrumb">
                <li>You are here</li>
                <li><a href="../Dashboard.aspx">Ei8ht POS</a></li>
                <li class="active">Sales</li>
            </ol>
        </div>
    </div>

    <div class="main searchFields">
        <div class="row padTop10">
            <div class="col-md-2 col-xs-12 tSize18 cwhite">
                Search Word :
            </div>
            <div class="col-md-4 col-xs-12">
                <asp:TextBox ID="txtSearch" runat="server" CssClass="textbox w100p" />
            </div>
        </div>
        <div class="row padTop10">
            <div class="col-md-2 col-xs-12 tSize18 cwhite">
                From Date :

            </div>
            <div class="col-md-4 col-xs-12">
                <asp:TextBox ID="txtFromDate" runat="server" CssClass="datepicker" />

            </div>
        </div>
        <div class="row padTop10">
            <div class="col-md-2 col-xs-12 tSize18 cwhite">To Date :</div>
            <div class="col-md-4 col-xs-12">
                <asp:TextBox ID="txtToDate" runat="server" CssClass="datepicker" />
            </div>
        </div>
        <div class="row padTop10">
            <div class="col-md-2 col-xs-12 tSize18 cwhite">Show </div>
            <div class="col-md-4 col-xs-12">
                <asp:CheckBox ID="chkShowPOS" runat="server" Text="Show POS Orders" CssClass="orderfilter cwhite" />
                <asp:CheckBox ID="chkShowWeb" runat="server" Text="Show Web Orders" CssClass="orderfilter cwhite" />
            </div>
        </div>
        <div class="row padTop10">
            <div class="col-md-2 col-xs-12 tSize18 cwhite"></div>
            <div class="col-md-4 col-xs-12">
                <asp:Button ID="btnSearch" runat="server" CssClass="btn-lg btn btn-primary loading" Text="Search"
                    OnClick="btnSearch_Click" />
                &nbsp;&nbsp;&nbsp;
                        <asp:Button ID="btnShowAll" runat="server" CssClass="btn-lg btn btn-primary loading" Text="Show All"
                            OnClick="btnShowAll_Click" />
            </div>
        </div>
    </div>

    <section class="tile contentField color">
        <div class="tile-header">
            <h1>Orders </h1><div class="pull-right">
                <asp:Button runat="server" ID="btnExport" OnClick="btnExportToExcel" CssClass="btn-lg btn btn-primary" Text="Export" />
            </div>
        </div>
        <div class="tile-body nopadding">

            <div class="responsive-table">
                <asp:GridView runat="server" ID="grdOrders" AllowPaging="true" PageSize="30" CssClass="table"
                    Width="98%" GridLines="Both" AutoGenerateColumns="false" OnPageIndexChanging="grdOrders_PageIndexChanging"
                    OnRowDataBound="grdOrders_RowDataBound">
                    <Columns>
                        <asp:TemplateField HeaderStyle-Width="20" HeaderStyle-HorizontalAlign="Center" ItemStyle-HorizontalAlign="Center"
                            HeaderText="Sl. No.">
                            <ItemTemplate>
                                <%# Container.DataItemIndex + 1  %>
                            </ItemTemplate>
                            <HeaderStyle HorizontalAlign="Center" Width="100px"></HeaderStyle>
                            <ItemStyle HorizontalAlign="Center"></ItemStyle>
                        </asp:TemplateField>
                        <asp:BoundField HeaderText="Order From" DataField="OrderFrom" />
                        <asp:BoundField HeaderText="Order Date" DataField="CreatedDate" DataFormatString="{0:dd/MM/yyyy}" />
                        <asp:TemplateField HeaderText="Order No.">
                            <ItemStyle HorizontalAlign="Left" />
                            <ItemTemplate>
                                <asp:HyperLink ID="linkViewDetails" runat="server" Text='<%# Eval("OrderNumber") %>'
                                    NavigateUrl='<%# String.Format("~/Admin/Sales/OrderDetails.aspx?UniqueID={0}", DataBinder.Eval(Container.DataItem,"UniqueID"))%>' />
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:BoundField HeaderText="Invoice No." DataField="InvoiceNo" />
                        <%--<asp:BoundField HeaderText="First Name" DataField="FirstName" />
                        <asp:BoundField HeaderText="Last Name" DataField="LastName" />
                        <asp:BoundField HeaderText="Email" DataField="Email" />
                        <asp:BoundField HeaderText="Contact No." DataField="BillingMobile" />
                        <asp:TemplateField HeaderText="Designer Info" Visible="false">
                            <ItemStyle HorizontalAlign="Center" />
                            <ItemTemplate>
                                <asp:LinkButton ID="lnkDesignerInfo" runat="server" Text="View" CommandArgument='<%# Eval("UniqueID") %>'
                                    OnClick="lnkDesignerInfo_Click" />
                            </ItemTemplate>
                        </asp:TemplateField>--%>
                        <%--<asp:BoundField HeaderText="Company" DataField="Company" />
                <asp:BoundField HeaderText="SubTotal" DataField="SubTotal" DataFormatString="{0:0.00}" />--%>
                        <asp:BoundField HeaderText="Discount" DataField="Discount" DataFormatString="{0:0.00}" />
                        <%--<asp:BoundField HeaderText="Shipping" DataField="Shipping" DataFormatString="{0:0.00}" />--%>
                        <%--<asp:BoundField HeaderText="GST" DataField="GST" DataFormatString="{0:0.00}" />--%>
                        <asp:BoundField HeaderText="Total" DataField="Total" DataFormatString="{0:0.00}" />
                        <asp:BoundField HeaderText="Payment Method" DataField="PaymentMethod" />
                        <%--<asp:BoundField HeaderText="Payment Status" DataField="PaymentStatus" />--%>
                        <asp:TemplateField HeaderText="Payment Status">
                            <ItemStyle HorizontalAlign="Center" />
                            <ItemTemplate>
                                <%# Eval("PaymentStatus") %>
                                <asp:PlaceHolder runat="server" ID="phPaymentStatus">
                                    <br />
                                    <asp:LinkButton ID="lnkPaymentStatus" runat="server" Text="Add" Font-Size="12px" CommandArgument='<%# Eval("UniqueID") %>'
                                        OnClick="lnkPaymentStatus_Click" /></asp:PlaceHolder>
                            </ItemTemplate>
                        </asp:TemplateField>

                        <asp:BoundField HeaderText="Order Status" DataField="OrderStatus" />
                        <asp:BoundField HeaderText="Date" DataField="EarliestAvailableDate" DataFormatString="{0:dd/MM/yyyy}" />
                        <asp:TemplateField HeaderText="Control" Visible="false">
                            <ItemStyle HorizontalAlign="Left" />
                            <ItemTemplate>
                                <asp:LinkButton ID="lnkEditOrder" runat="server" Text="Edit" CommandArgument='<%# Eval("UniqueID") %>'
                                    OnClick="lnkEditOrder_Click" />&nbsp;/&nbsp;
                        <asp:LinkButton ID="lnkHistroy" runat="server" Text="History" CommandArgument='<%# Eval("UniqueID") %>' OnClick="lnkHistroy_Click" />
                            </ItemTemplate>
                        </asp:TemplateField>
                    </Columns>
                    <PagerSettings Mode="NumericFirstLast" Visible="true" NextPageText="" PreviousPageText=""
                        Position="TopAndBottom" />
                    <PagerStyle CssClass="pg" HorizontalAlign="Right" VerticalAlign="Middle" BorderStyle="None"
                        Font-Bold="true" Font-Size="Medium" />

                    <HeaderStyle CssClass="tbl-header" />
                    <RowStyle CssClass="tbl-row" />
                    <AlternatingRowStyle CssClass="tbl-row" />
                    <EmptyDataRowStyle />
                    <EmptyDataTemplate>
                        No Record found
                    </EmptyDataTemplate>
                    <EmptyDataRowStyle VerticalAlign="Middle" HorizontalAlign="Center" />
                </asp:GridView>
            </div>
        </div>
    </section>

    <div class="row Footercenter">
        <center>All right reserved - www.ei8htpos.com &copy; 2015</center>
    </div>

    <div class="modal fade" id="divPayment" tabindex="-1" role="dialog" aria-labelledby="Payment" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                    <h4 class="modal-title" id="H1">Payment</h4>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12 col-xs-12">
                            <asp:Label ID="lblPayError" ForeColor="Red" runat="server" /></div>

                    </div>
                    <div class="row">
                        <div class="col-md-6 col-xs-12">Pay Method </div>
                        <div class="col-md-6 col-xs-12">
                            <asp:DropDownList ID="ddlPayMethod" runat="server" CssClass="listbox" Width="150px">
                                <asp:ListItem Selected="true" Value="0" Text="-- Please Select --" />
                                <asp:ListItem Value="Cash" Text="Cash" />
                                <asp:ListItem Value="Cheque" Text="Cheque" />
                                <asp:ListItem Value="Card" Text="Card" />
                            </asp:DropDownList>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 col-xs-12">Amount</div>
                        <div class="col-md-6 col-xs-12">
                            <asp:Label runat="server" ID="lblPayTotal" CssClass="adminlabel" /></div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 col-xs-12">Paid Amount</div>
                        <div class="col-md-6 col-xs-12">
                            <asp:TextBox runat="server" ID="txtPaidAmount" CssClass="textbox number" MaxLength="10" Width="80px" /></div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 col-xs-12">Code / Bank Name:</div>
                        <div class="col-md-6 col-xs-12">
                            <asp:TextBox runat="server" ID="txtBankName" CssClass="textbox" /></div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 col-xs-12">Cheque / Reference No.</div>
                        <div class="col-md-6 col-xs-12">
                            <asp:TextBox runat="server" ID="txtReferenceNo" CssClass="textbox" /></div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 col-xs-12"></div>
                        <div class="col-md-6 col-xs-12"></div>
                    </div>
                </div>
                <div class="modal-footer">
                    <asp:Button ID="btnSavePayment" runat="server" CssClass="btn btn-primary loading" Text="Save"
                        OnClick="btnSavePayment_Click" />
                    &nbsp;
                                <asp:Button ID="btnCancelPayment" runat="server" CssClass="btn btn-primary loading" Text="Cancel"
                                    OnClick="btnCancelPayment_Click" />
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="divPaymentStatus" tabindex="-1" role="dialog" aria-labelledby="Forgot Password" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                    <h4 class="modal-title" id="H3">Update Order Status</h4>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12 col-xs-12">
                            <asp:Label ID="lblEditError" ForeColor="Red" runat="server"></asp:Label></div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 col-xs-12">Payment Status</div>
                        <div class="col-md-6 col-xs-12">
                            <asp:DropDownList ID="ddlPaymentStatus" CssClass="log" runat="server">
                                <asp:ListItem Text="Completed" Value="Completed"></asp:ListItem>
                                <asp:ListItem Text="Pending" Value="Pending"></asp:ListItem>
                            </asp:DropDownList>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 col-xs-12">Order Status </div>
                        <div class="col-md-6 col-xs-12">
                            <asp:DropDownList ID="ddlOrderStatus" CssClass="log" runat="server">
                                <asp:ListItem Text="New" Value="New" Selected="True"></asp:ListItem>
                                <asp:ListItem Text="Pending" Value="Pending"></asp:ListItem>
                                <asp:ListItem Text="Delivered" Value="Delivered"></asp:ListItem>
                                <asp:ListItem Text="Canceled" Value="Canceled"></asp:ListItem>
                            </asp:DropDownList>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <asp:Button ID="btnSave" runat="server" CssClass="btn btn-primary loading" Text="Save"
                        OnClick="btnSave_Click" />
                    &nbsp;
                                <asp:Button ID="btnCancel" runat="server" CssClass="btn btn-primary loading" Text="Cancel"
                                    OnClick="btnCancel_Click" />
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="divDesignerInfo" tabindex="-1" role="dialog" aria-labelledby="Forgot Password" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                    <h4 class="modal-title" id="H4">Designer Info</h4>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6 col-xs-12">Designer Name</div>
                        <div class="col-md-6 col-xs-12">
                            <asp:TextBox ID="txtDesignerName" runat="server" CssClass="textbox" MaxLength="250" /></div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 col-xs-12">Remarks</div>
                        <div class="col-md-6 col-xs-12">
                            <asp:TextBox ID="txtDesignerRemarks" runat="server" CssClass="textbox" MaxLength="500" TextMode="MultiLine" /></div>
                    </div>
                </div>
                <div class="modal-footer">
                    <asp:Button ID="btnSaveDesigner" runat="server" CssClass="btn btn-primary loading" Text="Save"
                        OnClick="btnSaveDesigner_Click" />
                    &nbsp;
                                <asp:Button ID="btnCancelDesigner" runat="server" CssClass="btn btn-primary loading" Text="Cancel"
                                    OnClick="btnCancelDesigner_Click" />
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="divHistory" tabindex="-1" role="dialog" aria-labelledby="Forgot Password" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                    <h4 class="modal-title" id="H5">Order History</h4>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12 col-xs-12">
                            <div class="responsive-table">
                                <asp:GridView runat="server" ID="grdHistory" CssClass="table" Width="98%" GridLines="Both" AutoGenerateColumns="false"
                                    OnRowDataBound="grdHistory_RowDataBound">
                                    <Columns>
                                        <asp:TemplateField HeaderStyle-Width="20" HeaderStyle-HorizontalAlign="Center" ItemStyle-HorizontalAlign="Center"
                                            HeaderText="Sl. No.">
                                            <ItemTemplate>
                                                <%# Container.DataItemIndex + 1  %>
                                            </ItemTemplate>
                                            <HeaderStyle HorizontalAlign="Center" Width="50px"></HeaderStyle>
                                            <ItemStyle HorizontalAlign="Center" />
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="Name">
                                            <ItemStyle HorizontalAlign="Left" VerticalAlign="Top" />
                                            <ItemTemplate>
                                                <asp:Label runat="server" ID="lblName" Style="width: 200px; white-space: nowrap; overflow: hidden; text-overflow: ellipsis;" />
                                            </ItemTemplate>
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="Remarks">
                                            <ItemStyle HorizontalAlign="Left" VerticalAlign="Top" />
                                            <ItemTemplate>
                                                <asp:Label runat="server" ID="lblRemarks" Style="width: 200px; white-space: nowrap; overflow: hidden; text-overflow: ellipsis;" />
                                            </ItemTemplate>
                                        </asp:TemplateField>
                                        <asp:BoundField HeaderText="Date" DataField="CreatedDate" DataFormatString="{0:dd/MM/yyyy}" />
                                        <asp:BoundField HeaderText="Time" DataField="CreatedDate" DataFormatString="{0:HH:mm}" />
                                        <asp:BoundField HeaderText="IP Address" DataField="IPAddress" />
                                    </Columns>
                                    <PagerSettings Mode="NumericFirstLast" Visible="true" NextPageText="" PreviousPageText=""
                                        Position="TopAndBottom" />
                                    <PagerStyle CssClass="pg" HorizontalAlign="Right" VerticalAlign="Middle" BorderStyle="None"
                                        BackColor="#ffffff" />
                                    <HeaderStyle CssClass="tbl-header" />
                                    <RowStyle CssClass="tbl-row" />
                                    <AlternatingRowStyle CssClass="tbl-altrow" />
                                    <EmptyDataRowStyle />
                                    <EmptyDataTemplate>
                                        No Record found
                                    </EmptyDataTemplate>
                                    <EmptyDataRowStyle VerticalAlign="Middle" HorizontalAlign="Center" />
                                </asp:GridView>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>


</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="ScriptContent" runat="server">
    <script>
        $(document).ready(function () {
            $('.orderfilter input').click(function () {
                if ($(this).is(':checked')) {
                    $('.orderfilter input').each(function () {
                        $(this).prop('checked', false);
                    })
                    $(this).prop('checked', true);
                }
            })
        });
    </script>
</asp:Content>
